CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	
	IF EXISTS (SELECT 1 FROM pg_views 
                    WHERE viewname = 'v_movimento_por_ecf_r04') THEN 
		DROP VIEW IF EXISTS v_movimento_por_ecf_r04;
        RAISE NOTICE 'v_movimento_por_ecf_r04 removida.';
    END IF; 

CREATE OR REPLACE VIEW public.v_movimento_por_ecf_r04
AS SELECT pdv_vd.cd_emp,
    pdv_vd.cd_filial,
    pdv_vd.cd_cx,
    pdv_vd.cont_cupom_fisc,
    pdv_vd.nr_ecf,
    pdv_vd.dt_vd,
    pdv_vd.vlr_vd,
    pdv_vd.vlr_desc,
    pdv_vd.vlr_liq_vd,
    pdv_vd.st_vd,
    pdv_vd.nm_cli,
    pdv_vd.cgc_cpf,
    pdv_vd.nr_serie_imp,
    ( SELECT pdv_cx.modelo_ecf
           FROM pdv_cx
          WHERE pdv_vd.cd_emp = pdv_cx.cd_emp AND pdv_vd.cd_filial = pdv_cx.cd_filial AND pdv_vd.cd_cx = pdv_cx.cd_cx) AS modelo_ecf,
        CASE
            WHEN COALESCE(pdv_vd.reg_alterado::boolean, false) = true THEN 1
            ELSE 0
        END AS reg_alterado
   FROM pdv_vd;

	ALTER TABLE v_movimento_por_ecf_r04  OWNER TO postgres;
		
		
	RAISE NOTICE 'View v_movimento_por_ecf_r04 recriada.'; 
       
END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();